#'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"#
#~	 DX Generic LIB Makefile	~#
#'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"'"~.,.~"#

#if invoked refer to this makefiles usage instructions
DX_LIB_first: DX_LIB_usage
	

#for debug set to non-empty:
DEBUG =

#include the platform constant commands and definitions
include $(MF_PATH)DX_CMDS.inc

#read which components exist
include $(MF_PATH)DX_COMP_LIST.inc
#The components makefiles will be included and built if their ID is active (project settings)
COMPONENTS = $(DX_COMPONENTS_LIST)

COMPONENTS_MF = $(addprefix $(MF_PATH),$(addsuffix .$(MFEXT),$(COMPONENTS)))
include $(COMPONENTS_MF)

TARGET = $(OUT_LIB_PATH)DX_$(PROJECT)_LIB.$(LIBEXT)



DX_LIB_main: DX_LIB_debug COMP_debug $(TARGET)
	@echo $@ STOP.

#for debug set to the wanted component id:
#COMP_NAME = $(KMNG_ID)

COMPONENTS_TARGETS = $(addsuffix _OBJECTS_TARGET,$(COMPONENTS))

COMPONENTS_OBJECTS =
COMPONENTS_OBJECTS += $(foreach COMP,$(COMPONENTS), $($(addsuffix _OBJS,$(COMP))))

$(TARGET):  $(OUT_OBJ_PATH) $(OUT_LIB_PATH) $(COMPONENTS_TARGETS) 
	$(AR) $(GEN_ARFLAGS) $@ $(COMPONENTS_OBJECTS)
	$(CHECK_TARGET_COMPLETE)

DX_LIB_debug: 
	$(ECHO) PROJECT: $(PROJECT)
	$(ECHO) DX_LIB_TARGET: $(TARGET)
	$(ECHO) COMPONENTS: $(COMPONENTS)
	$(DEBUG_ECHO) COMPONENTS_MF $(COMPONENTS_MF)
	$(DEBUG_ECHO) COMPONENTS_TARGETS $(COMPONENTS_TARGETS)

COMP_debug:
	$(DEBUG_ECHO) COMP_NAME $(COMP_NAME)
	$(DEBUG_ECHO) $(COMP_NAME)_API_INCL_PATH $($(COMP_NAME)_API_INCL_PATH)
	$(DEBUG_ECHO) $(COMP_NAME)_INCL_PATHS $($(COMP_NAME)_INCL_PATHS)
	$(DEBUG_ECHO) $(COMP_NAME)_CCFLAGS $($(COMP_NAME)_CCFLAGS)
	$(DEBUG_ECHO) $(COMP_NAME)_OBJECTS_CCFLAGS $($(COMP_NAME)_OBJECTS_CCFLAGS)
	$(DEBUG_ECHO) $(COMP_NAME)_OBJS $($(COMP_NAME)_OBJS)

DX_LIB_clean:
	$(ECHO) Deleting all objects and libraries...
	-@$(RM) $(OUT_OBJ_PATH:/=$(DIR_SEP))*.$(OBJEXT)
	-@$(RM) $(OUT_LIB_PATH:/=$(DIR_SEP))*.$(LIBEXT)
	$(ECHO) Done.

$(OUT_OBJ_PATH) $(OUT_LIB_PATH):
	-$(MKDIR) $(@:/=$(DIR_SEP))

DX_LIB_rebuild: DX_LIB_clean DX_LIB_main
	

DX_LIB_usage:
	@echo This makefile should not run on its own.
	@echo It's meant to be used by another makefile for generic LIB build.